
Start-Transcript -path C:\cloudbase-install-ssh.log -Append -force
$filePath = "C:\cloudbase-init-run.txt" 

$date = get-date
Get-WindowsCapability -Name OpenSSH.Server* -Online |
Add-WindowsCapability -Online
Set-Service -Name sshd -StartupType Automatic -Status Running

$firewallParams = @{
	Name        = 'sshd-Server-In-TCP'
	DisplayName = 'Inbound rule for OpenSSH Server (sshd) on TCP port 22'
	Action      = 'Allow'
	Direction   = 'Inbound'
	Enabled     = 'True'  # This is not a boolean but an enum
	Profile     = 'Any'
	Protocol    = 'TCP'
	LocalPort   = 22
}
New-NetFirewallRule @firewallParams

$shellParams = @{
	Path         = 'HKLM:\SOFTWARE\OpenSSH'
	Name         = 'DefaultShell'
	Value        = 'C:\Windows\System32\WindowsPowerShell\v1.0\powershell.exe'
	PropertyType = 'String'
	Force        = $true
}
New-ItemProperty @shellParams

# Set default to powershell.exe
$shellParams = @{
	Path         = 'HKLM:\SOFTWARE\OpenSSH'
	Name         = 'DefaultShell'
	Value        = 'C:\Windows\System32\WindowsPowerShell\v1.0\powershell.exe'
	PropertyType = 'String'
	Force        = $true
}
New-ItemProperty @shellParams

$ipconfig = ipconfig /all
$dhcpServer = ($ipconfig | Select-String "DHCP Server").ToString().Split(":")[-1].Trim()

# stop the SSHD service
stop-service sshd

# apply the SSHD config - output the file
$sshdconf = " IyBUaGlzIGlzIHRoZSBzc2hkIHNlcnZlciBzeXN0ZW0td2lkZSBjb25maWd1cmF0aW9uIGZpbGUuICBTZWUNCiMgc3NoZF9jb25maWcoNSkgZm9yIG1vcmUgaW5mb3JtYXRpb24uDQoNCiMgQXV0aGVudGljYXRpb246DQpQdWJrZXlBdXRoZW50aWNhdGlvbiB5ZXMNClBhc3N3b3JkQXV0aGVudGljYXRpb24gbm8NCkF1dGhvcml6ZWRLZXlzRmlsZQkuc3NoL2F1dGhvcml6ZWRfa2V5cw0KTWF0Y2ggR3JvdXAgYWRtaW5pc3RyYXRvcnMNCiAgICAgICBBdXRob3JpemVkS2V5c0ZpbGUgX19QUk9HUkFNREFUQV9fL3NzaC9hZG1pbmlzdHJhdG9yc19hdXRob3JpemVkX2tleXM="

$outfile="C:\ProgramData\ssh\sshd_config2"
[IO.File]::WriteAllBytes($outfile, [Convert]::FromBase64String($sshdconf)) 

# SSH Key Configuration
$sshkey = Invoke-RestMethod -method GET -uri "http://$dhcpServer/latest/meta-data/public-keys" -UseBasicParsing
$authorizedKey = ($sshkey).Trim()
Add-Content -Force -Path "C:\ProgramData\ssh\administrators_authorized_keys" -Value $authorizedKey;icacls.exe "C:\ProgramData\ssh\administrators_authorized_keys" /inheritance:r /grant "Administrators:F" /grant "SYSTEM:F"

# restart the SSHD service
start-service sshd

# hide the search bar and server manager
Set-ItemProperty -Path HKCU:\SOFTWARE\Microsoft\Windows\CurrentVersion\Search -Name SearchboxTaskbarMode -Value 0 -Type DWord -Force
Set-ItemProperty -Path HKCU:\Software\Microsoft\ServerManager -Name "CheckedUnattendLaunchSetting" -Value 0 -Type DWord -Force
Set-ItemProperty -Path HKCU:\Software\Microsoft\ServerManager -Name "DoNotOpenServerManagerAtLogon" -Value 1 -Type DWord -Force

# Run sysprep again to reset user info
#cd C:\windows\system32\sysprep\
#.\sysprep.exe /generalize /oobe /reboot /mode:vm /unattend:"C:\Program Files\Cloudbase Solutions\Cloudbase-Init\conf\Unattend_generic.xml"

# reset the admin password
Add-Type -Assembly System.Web
$password = [Web.Security.Membership]::GeneratePassword(14,4)
#net user administrator $password
echo $password

echo "Cloudbase-init process completed: $date" > $filePath 
Stop-Transcript
