source "qemu" "server-2025-std-core" {
    vm_name             = "server2025-std-core"
#    iso_url          = local.iso_url_win_2k25
#    iso_url          = "http://172.31.1.212/isos/_win/server2025-vlsc-noprompt.iso"
    iso_url          = "/isos/_win/server2025-vlsc-noprompt.iso"
#    iso_checksum     = local.iso_checksum_url_win_2k25
    iso_checksum     = "df4843fbd3a2006261f60ad20914e73c11b9359c494e73dfed1e6a477b05ad90"
    accelerator      = "kvm"
    boot_wait        = "10s"
    communicator     = "winrm"
    cpus             = "4"
    disk_compression = "true"
    disk_interface   = "virtio"
    disk_size        = "61440"
    floppy_files     = [ "./answer_files/2025/standard_core/Autounattend.xml","./drivers/*" ]
    floppy_dirs      = ["./floppy/*","./scripts"]
    format           = "qcow2"
    headless         = "true"
    memory           = "8192"
    net_device       = "virtio-net"
    qemuargs         = [["-vga", "qxl"], ["-cpu", "host"], ["-bios","/usr/share/OVMF/OVMF_CODE.fd"]]
#    qemuargs         = [["-vga", "qxl"], ["-cpu", "host"]]
    shutdown_command = "C:\\windows\\system32\\sysprep\\sysprep.exe /generalize /oobe /quiet /mode:vm /shutdown"
#    shutdown_command = "C:\\windows\\system32\\sysprep\\sysprep.exe /generalize /oobe /quiet /mode:vm /shutdown /unattend:'C:\Program Files\Cloudbase Solutions\Cloudbase-Init\conf\Unattend.xml'"
    winrm_insecure   = true
    winrm_timeout    = "60m"
    winrm_username   = "Administrator"
    winrm_password   = "SuperS3cr3t!!!"
#    winrm_password   = "N0tS3cUr3Password"
    output_directory = "./builds/qemu/"
    vnc_bind_address = "0.0.0.0"
#    firmware         = "uefi"
#    efi_boot         = "true"
#    machine_type     = "q35"
#    efi_firmware_code = "/usr/share/OVMF/OVMF_CODE.fd"
#    efi_firmware_vars = "/usr/share/OVMF/OVMF_VARS.fd"
#    vtpm              = true
#    vtpm             = true
#    cpu_model        = "host"
}

build {
  sources = ["source.qemu.server-2025-std-core"]

  provisioner "powershell" {
    scripts = fileset(".", "scripts/*.ps1")
    valid_exit_codes=["0","3010"]
  }

  provisioner "powershell" {
    scripts = fileset(".", "scripts/sysprep/99_prepare-for-sysprep.ps1")
  }
}
