Write-Host "Installing VirtIO drivers"

 # Start logging
start-transcript -path "C:\Windows\temp\virtio-driver-install.log"

#download VirtIO installer
write-host "Downloading VirtIO Driver ISO"
$virtiourl = "https://fedorapeople.org/groups/virt/virtio-win/direct-downloads/stable-virtio/virtio-win.iso"
$isopath = "C:\windows\temp\virtio-win.iso"
$client = new-object System.Net.WebClient
$client.DownloadFile("$virtiourl", "$isopath")

write-host "Mounting VirtIO ISO"
$mountimage = Mount-DiskImage -ImagePath $isopath
$driveletter = ($mountimage | get-volume).DriveLetter

# output the certificate
write-host "Installing VirtIO Certificate"
$certfile = "C:\Windows\temp\RedHat.cer"
$winversion = ((Get-WmiObject -class Win32_OperatingSystem).Caption -replace "[^0-9]" , '' -replace "[0]" , 'k')
$netkvmpath = "${driveletter}:\NetKVM\${winversion}\amd64"
$netkvminf = "${netkvmpath}\netkvm.inf"
cp $netkvminf C:\Windows\Temp\
$cert = (Get-AuthenticodeSignature ($netkvminf)).SignerCertificate
$exportType = [Security.Cryptography.X509Certificates.X509ContentType]::Cert
$exportcert = [IO.File]::WriteAllBytes($certfile, $cert.Export($exportType))
certutil.exe -addstore -f TrustedPublisher $certFile

# install the drivers
#$drivers = "balloon","fwcfg","netkvm","qxl","viofs","viogpudo","vioinput","vioprot","viorng","vioscsi","vioserial","viostor","viomem","sriov","smbus"
#$drivers = "balloon","fwcfg","qxl","viofs","viogpudo","vioinput","vioprot","viorng","vioscsi","vioserial","viostor","viomem","sriov","smbus"
$drivers = "balloon","qxl","viofs","vioscsi","vioserial","viostor","vioserial","smbus","sriov"
foreach ($driver in $drivers){
write-host "Installing VirtIO driver: $driver"
$infpath = "${driveletter}:\$driver\$winversion\amd64\*.inf"
pnputil.exe /add-driver $infPath /install

if ($driver -eq "balloon"){
 write-host "installing VirtIO balloon service"
 invoke-expression  "${driveletter}:\$driver\$winversion\amd64\blnsvr.exe -i"
 }
 
}

# install the guest agent
write-host "Installing QEMU Guest Agent"
Start-Process msiexec -ArgumentList "/i ${driveletter}:\virtio-win-gt-x64.msi /log C:\Windows\Temp\qemu-guest-agent.log /qn /passive /norestart ADDLOCAL=ALL"

Write-host "Drivers installed, cleaning up"
# Unmount and remove the ISO
Dismount-DiskImage -ImagePath $isopath
#Remove-Item -Path $isopath

# Finish
Stop-Transcript 
